/*
* KAMATSU'S CLASS LIBRARY
* Version 0.45
*  
* Created by Kamatsu
* 
* Released under the MIT license.
* 
* Copyright (C) 2007 Liam O'Connor-Davis e.a. Only a couple of rights reserved.
* Feel free to use/modify this for your projects, provided this copyright notice
* remains intact.
*
* Also, no warranty. Either expressed or implied, including the implied warranties
* of merchantability or fitness for a particular purpose. 
*
* Enjoy.
*
*/

/*

kclWrapperClasses.js: Classes that wrap around native sphere objects directly.

THESE CLASSES ARE BEING PHASED OUT AS SPHERE IMPLEMENTS THEM. HENCE ADJUSTMENTS
MAY BE MADE. USE THIS AT YOUR OWN RISK
*/

try {
    LibraryRegistry.abortIfNotInstalled("Spheritype",1.1,false);
}
catch (ex) {
    Abort("Spheritype Not Installed!");
}

LibraryRegistry.abortIfNotInstalled("Kamatsu's Class Library: Declares",0.45, true); //Versions must equate :), hence the strict arg.
LibraryRegistry.addLibraryData("Kamatsu's Class Library: Wrapper Classes",0.45);


/* OBJECT: Font
    Parameters (optional): 
       * fontfile - file of font to load or a sphere font. Uses game.font if not specified.
       
       
    Non-parametised Properties:
       * s_font - the underlying sphere font.
       
    Inherits from: Nothing

    A font wrapper object to bring it up to speed, and enable extensions if desired.
*/
var Font = Class.extend({

    s_font: undefined,

    constructor: function (fontfile) {
    if (fontfile){
            if (typeof fontfile == 'string'){
                this.s_font = LoadFont(fontfile);
            }else{
                this.s_font = fontfile.clone();
	    }
        }else{ 
            this.s_font = Game.font;
      }
    },

    
    //S_FONT FUNCTION WRAPPERS:
    getStringWidth: function (string) {
        return this.s_font.getStringWidth(string);
    },
    
    getStringHeight: function (string,width) {
        return this.s_font.getStringWidth(string,width);
    },
    
    getColorMask: function () {    
        return new Color(this.s_font.getColorMask().red,this.s_font.getColorMask().green,this.s_font.getColorMask().blue,this.s_font.getColorMask().alpha);
    },
    
    getHeight: function () {
        return this.s_font.getHeight();
    },
    
    drawText: function (x, y, text) {
        return this.s_font.drawText(x,y,text);
    },
    
    drawTextBox: function (x, y, width, height, y_offset, text) {
        return this.s_font.drawTextBox(x, y, width, height, y_offset, text);
    },
    
    drawZoomedText: function (x, y, scale, text) {
        return this.s_font.drawZoomedText(x,y,scale,text);
    },
    
    setColorMask: function (color) {
	if(color.s_color)
        	this.s_font.setColorMask(color.s_color);
	else
        	this.s_font.setColorMask(color);
        return this;
    }

});

/* OBJECT: Image
    Parameters (optional): 
       * imagefile - file of image to load OR "system_arrow" OR "system_arrow_down" OR "system_arrow_up" OR "from_buffer".
       * mask - A mask color to use, optional.
       * x, y, w, h - Dimensions of grabImage if "from_buffer" is chosen.
       
       
    Non-parametised Properties:
       * s_image - the underlying sphere image.
       
       
    Inherits from: Nothing

    An image wrapper object to bring it up to speed, and enable extensions if desired. Uses a mask property instead of a function argument, width and height Get functions rather than properties.
*/

var Image = Class.extend({

    constructor: function (imagefile,mask, x, y, w, h) {
      if (imagefile == IMAGE_ARROW) {
          this.s_image = Game.systemArrow
      } else
      if (imagefile == IMAGE_ARROW_UP) {
          this.s_image = Game.systemArrowUp
      } else     
      if (imagefile == IMAGE_ARROW_DOWN) {
          this.s_image = Game.systemArrowDown
      } else     
      if (imagefile == IMAGE_FROM_BUFFER) {
          this.s_image = GrabImage(x,y,w,h);
      } else 
      if (imagefile != IMAGE_NONE) {
          if(typeof imagefile == 'string')
          	this.s_image = LoadImage(imagefile);
	  else
          	this.s_image = imagefile.clone();

      } 
      
      if (mask) this.mask = mask; else     
          this.mask = new Color(255,255,255,255);
      
    },

    s_image: undefined,
    
    mask: undefined,
    
    
    //S_IMAGE FUNCTION WRAPPERS
    
    getWidth: function () { return this.s_image.width; },
    
    getHeight: function () { return this.s_image.height; },
    
    
    blit: function (x,y) {
        if (this.mask && this.mask != IMAGE_NONE) {
           return  this.s_image.blitMask(x,y, this.mask.s_color)
        }
        else {
           return  this.s_image.blit(x,y);
        }
    },



    rotateBlit: function (x,y,radians) {
        if (this.mask && this.mask != IMAGE_NONE) {
            return this.s_image.rotateBlitMask(x,y, radians, this.mask.s_color)
        }
        else {
            return this.s_image.rotateBlit(x,y, radians);
        }
    },
    
    zoomBlit: function (x,y,scale) {
        if (this.mask && this.mask != IMAGE_NONE) {
            return this.s_image.zoomBlitMask(x,y, scale, this.mask.s_color)
        }
        else {
            return this.s_image.zoomBlit(x,y, scale);
        }
    },
    
    transformBlit: function (x1,y1,x2,y2,x3,y3,x4,y4) {
        if (this.mask && this.mask != IMAGE_NONE) {
            return this.s_image.transformBlitMask(x1,y1,x2,y2,x3,y3,x4,y4, this.mask.s_color)
        }
        else {
            return this.s_image.transformBlit(x1,y1,x2,y2,x3,y3,x4,y4);
        }
    
    },
    
    toSurface: function () {
       var temp = new Surface();
       temp.s_surface = this.s_image.createSurface();
       return temp;
    
    }
     
    
});



/* OBJECT: Color
    Parameters: 
       * r, g, b, a - Color Values
       
       
    Non-parametised Properties:
       * s_color - the underlying sphere color.
       
       
    Inherits from: Nothing

    A color wrapper object to bring it up to speed, and enable extensions if desired. Includes a few extra bits and pieces formerly in the global scope.
*/

var Color = Class.extend({

    constructor: function (r,g,b,a) {
        this.s_color = CreateColor(r,g,b,a);
    },

    s_color: undefined,
    
    
    //Wrappers from Global Scope.
    
    blendedWith: function (color) {
        return BlendColors(this.s_color,color.s_color);
    },
    
    
    
    blendedWeightedWith: function (color, weight1,weight2) {
        return BlendColorsWeighted(this.s_color,color.s_color,weight1,weight2);
    },
    
    
    //S_COLOR WRAPPERS
    
    getRed: function() {
        return this.s_color.red;
    }, 

    getGreen: function() {
        return this.s_color.green;
    }, 
    
    getBlue: function() {
        return this.s_color.blue;
    }, 
    
    getAlpha: function() {
        return this.s_color.alpha;
    }

});

/* OBJECT: WindowStyle
    Parameters (optional): 
       * filename - Filename of windowstyle to load.
       
    Non-parametised Properties:
       * s_style - the underlying sphere style.
       
       
    Inherits from: Nothing

    A windowstyle wrapper object to bring it up to speed, and enable extensions if desired. 
*/


var WindowStyle = Class.extend({

    constructor: function (filename) {
        this.s_style = Game.windowStyle;
    if (filename) {
          if (typeof filename == 'string') {
            this.s_style = LoadWindowStyle(filename);
          }
          else if (this.filename == WINDOWSTYLE_DEFAULT) {
          }
          else {
            this.s_style = Game.windowStyle.clone();
          }
        }
        
    },
    
    s_style: undefined,
    
    setColorMask: function (color) {
        return this.s_style.setColorMask(color.s_color);
    },
    
    getColorMask: function (color) {
        return new Color(this.s_style.getColorMask().red,this.s_style.getColorMask().green,this.s_style.getColorMask().blue,this.s_style.getColorMask().alpha);
    },
    
    drawWindow: function(x,y,w,h) {
        return this.s_style.drawWindow(x,y,w,h);
    }
    
});

/* OBJECT: Surface
    Parameters (optional): 
       * width,height,color - Creates a surface of width,height, filled with bg color. Color is expected to be a CL Color object of course. Otherwise no defined surface.
       
       
       
       
    Non-parametised Properties:
       * s_surface - the underlying sphere surface.
       
       
    Inherits from: Nothing

    An surface wrapper object to bring it up to speed, and enable extensions if desired. 
*/

var Surface = Class.extend({

    constructor: function (w,h,color) {
        if (w && h && color) {
            this.s_surface = CreateSurface(w,h,color.s_color);
        }
    },

    s_surface: undefined,
    
    loadFromImage: function (imagefile) {
        return this.s_surface = LoadSurface(imagefile);
    },
    
    loadFromBuffer: function (x,y,w,h) {
        return this.s_surface = GrabSurface(x,y,w,h);
    },
    
    
    
    //S_SURFACE FUNCTION WRAPPERS
    
    getWidth: function () { return this.s_surface.width; },
    
    getHeight: function () { return this.s_surface.height; },
    
    
    blit: function (x,y) {
        return this.s_surface.blit(x,y);
    },

    applyLookup: function (x,y,w,h,r,g,b,a) {
        this.s_surface.applyLookup(x,y,w,h,r,g,b,a);
        return this;
    },
    
    applyColorFX: function (x,y,w,h,matrix) {
        this.s_surface.applyColorFX(x,y,w,h,matrix.s_matrix);
        return this;
    },
    
    applyColorFX4: function (x,y,w,h,matrix1,matrix2,matrix3,matrix4) {
        this.s_surface.applyColorFX(x,y,w,h,matrix1.s_matrix,matrix2.s_matrix,matrix3.s_matrix,matrix4.s_matrix);
        return this;
        
    },
    
    blitSurface: function (surface,x,y) {
        return this.s_surface.blitSurface(surface.s_surface,x,y);
    },
    
    toImage: function () {
        var temp = new Image(IMAGE_NONE);
        temp.s_image = this.s_surface.createImage();
        return temp;
    },
    
    setBlendMode: function (mode) {
        this.s_surface.setBlendMode(mode);
        return this;
    },
    
    getPixel: function (x,y) { 
        return new Color(this.s_surface.getPixel(x,y).red,this.s_surface.getPixel(x,y).green,this.s_surface.getPixel(x,y).blue,this.s_surface.getPixel(x,y).alpha);
    }  ,
    
    setPixel: function (x,y,color) {
        this.s_surface.setPixel(x,y,color.s_color);
        return this;
    },
    
    setAlpha: function (alpha) {
        this.s_surface.setAlpha(alpha);
        return this;
    },
    
    replaceColor: function (oldColor,newColor) {
        this.s_surface.replaceColor (oldColor.s_color,newColor.s_color);
        return this;
    },
    
    line: function (x1,y1,x2,y2,color) {
        this.s_surface.line(x1,y1,x2,y2,color.s_color);
        return this;
    },
    
    rectangle: function(x,y,w,h,color) {
        this.s_surface.rectangle(x,y,w,h,color.s_color);
        return this;
        
    },
    
    triangle: function(x1,y1,x2,y2,x3,y3,color) {
        this.s_surface.triangle(x1,y1,x2,y2,x3,y3,color.s_color);
        return this;
    },
    
    rotate: function(radians,resize) {
        this.s_surface.rotate(radians,resize);
        return this;
    },
    
    resize: function(w,h) {
        this.s_surface.resize(w,h);
        return this;
    },
    
    rescale: function(w,h) {
        this.s_surface.rescale(w,h);
        return this;
    },
    
    flipHorizontally: function () {
        this.s_surface.flipHorizontally();
        return this;
    },
    
    flipVertically: function () {
        this.s_surface.flipVertically();
        return this;
    },
    
    clone: function () {
        var temp = new Surface() 
        temp.s_surface = this.s_surface.clone();
        return temp;
    },

    cloneSection: function (x,y,w,h) {
        var temp = new Surface() 
        temp.s_surface = this.s_surface.cloneSection(x,y,w,h);
        return temp;
    }, 
    
    drawText: function (font,x,y,text) {
        this.s_surface.drawText(font.s_font,x,y,text);
        return this;
    },
    
    drawTextBox: function (font,x,y,w,h,offset,text) {
        this.s_surface.drawTextBox(font.s_font,x,y,w,h,offset,text);
        return this;
    },     
    
    save: function (filename) {
        return this.s_surface.save(filename);
    }
    
});


/* OBJECT: ColorMatrix
    Parameters: 
       * (rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb) - Color Values as per sphere ColorMatrix object.
       
       
    Non-parametised Properties:
       * s_color - the underlying sphere color.
       
       
    Inherits from: Nothing

    A color matrix wrapper object to bring it up to speed, and enable extensions if desired.
*/

var ColorMatrix = Class.extend({

    construct: function (rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb) {
        this.s_matrix = CreateColorMatrix(rn, rr, rg, rb,  gn, gr, gg, gb,  bn, br, bg, bb);
    },

    s_matrix: undefined,
  
});

